@extends('layouts.admin')

@section('title', 'News Management')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>News Management</h1>
            @can('create news')
            <a href="{{ route('admin.news.create') }}" class="btn btn-primary">
                <i class="fas fa-plus-circle"></i> Create News Article
            </a>
            @endcan
        </div>
        <p>Manage your news articles</p>
    </div>
    
    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>News Articles</h3>
        </div>
        <div class="dashboard-card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Author</th>
                            <th>Date</th>
                            <th>Reading Time</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($news as $article)
                        <tr>
                            <td>{{ $article->id }}</td>
                            <td>
                                @if($article->image)
                                    <img src="{{ Storage::url($article->image) }}" alt="{{ $article->title }}" class="avatar-sm">
                                @else
                                    <i class="fas fa-newspaper"></i>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.news.show', $article) }}" class="thread-link">
                                    {{ $article->title }}
                                </a>
                                <div class="thread-stats">
                                    {{ Str::limit($article->short_description, 50) }}
                                </div>
                            </td>
                            <td>{{ $article->author->name }}</td>
                            <td>{{ $article->formatted_date }}</td>
                            <td>{{ $article->reading_time }}</td>
                            <td class="user-actions">
                                <a href="{{ route('admin.news.show', $article) }}" class="btn-icon btn-primary" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                @can('manage news')
                                <a href="{{ route('admin.news.edit', $article) }}" class="btn-icon btn-success" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @endcan
                                @can('delete news')
                                <form action="{{ route('admin.news.destroy', $article) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this news article?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn-icon btn-danger" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                @endcan
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center">No news articles found</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-md">
                {{ $news->links() }}
            </div>
        </div>
    </div>
</div>
@endsection